# usage: awk -f wt_fmx.awk param=num_clk alt_tmp.fmx
#  purge register source which has same frequency as clock source
#  if no need to add macrofunction path, then output to acf
#  else output to alt_tmp.fmh
BEGIN {FS= " "; prev= " "; out_fmax= 0; clk_fmax= 0;}
$3 != prev {
 	    if ( out_fmax == 1)  
	    {
              printf("%s :FREQUENCY \"%.2fns {synopsys}\"\n", prev, fmax);
	    }
	    prev= $3;
	    out_fmax= 0;
	   }


$2 ~ /CKCYL/ {fmax= $1; clk_fmax= $1; out_fmax= 1;}
$2 ~ /FMAX/ {
		# purge same frequenc only when one clock
		if ( param > 1 || $1 != clk_fmax) 
		{
		   fmax= $1;
	    	   out_fmax = 1;
		}
	    }
END {
 	    if ( out_fmax == 1)  
	    {
              printf("%s :FREQUENCY \"%.2fns {synopsys}\"\n", prev, fmax);

            }
}
